/*************************************************

audiocap.h
used by tw686x

**************************************************/

#ifndef AUDIOCAP_H
#define AUDIOCAP_H

typedef struct {
    char name[PATH_MAX];
    int  fd;
    int  sample_rate;
    int  bits;
    int  channels;
    int  length;
} wav_file_t;

int audio_play_open(gui_t *gui);
int audio_play_close(gui_t *gui);

int wav_open(wav_file_t *wav);
int wav_write(wav_file_t *wav, unsigned char *data, int length);
int wav_close(wav_file_t *wav);

int audio_device_open  (channel_t * chl);
int audio_device_close (channel_t * chl);
int audio_device_setfmt(channel_t *chl);

#endif
