﻿
Imports QCAP.NET

Public Class MySetupControl

    Public m_pMainForm As Form1

    Public m_hCapDev1 As UInt32 = 0, m_hCapDev2 As UInt32 = 0, m_hCapDev3 As UInt32 = 0, m_hCapDev4 As UInt32 = 0

    Public m_strFormatChangedOutput1 As String = " INFO :  . . .", m_strFormatChangedOutput2 As String = " INFO :  . . .", m_strFormatChangedOutput3 As String = " INFO :  . . .", m_strFormatChangedOutput4 As String = " INFO :  . . ."
    
    Public m_strCurrentDir As String = ""

    Public m_bAutoDeinterlace As Boolean = True

    Public m_bNoSignal1 As Boolean = True, m_bNoSignal2 As Boolean = True, m_bNoSignal3 As Boolean = True, m_bNoSignal4 As Boolean = True

    Public m_bIsRecord1_1 As Boolean = False, m_bIsRecord1_2 As Boolean = False, m_bIsRecord2_1 As Boolean = False, m_bIsRecord2_2 As Boolean = False

    Public m_bIsRecord3_1 As Boolean = False, m_bIsRecord3_2 As Boolean = False, m_bIsRecord4_1 As Boolean = False, m_bIsRecord4_2 As Boolean = False

    Public m_bSupportGPU1_1 As Boolean = False, m_bSupportGPU1_2 As Boolean = False, m_bSupportGPU2_1 As Boolean = False, m_bSupportGPU2_2 As Boolean = False

    Public m_bSupportGPU3_1 As Boolean = False, m_bSupportGPU3_2 As Boolean = False, m_bSupportGPU4_1 As Boolean = False, m_bSupportGPU4_2 As Boolean = False

    Public m_bCheckedAVI1_1 As Boolean = True, m_bCheckedAVI1_2 As Boolean = True, m_bCheckedAVI2_1 As Boolean = True, m_bCheckedAVI2_2 As Boolean = True

    Public m_bCheckedAVI3_1 As Boolean = True, m_bCheckedAVI3_2 As Boolean = True, m_bCheckedAVI4_1 As Boolean = True, m_bCheckedAVI4_2 As Boolean = True

    Public m_bCheckedMP41_1 As Boolean = False, m_bCheckedMP41_2 As Boolean = False, m_bCheckedMP42_1 As Boolean = False, m_bCheckedMP42_2 As Boolean = False

    Public m_bCheckedMP43_1 As Boolean = False, m_bCheckedMP43_2 As Boolean = False, m_bCheckedMP44_1 As Boolean = False, m_bCheckedMP44_2 As Boolean = False

    Public m_strAviName1_1 As String, m_strAviName1_2 As String, m_strAviName2_1 As String, m_strAviName2_2 As String

    Public m_strAviName3_1 As String, m_strAviName3_2 As String, m_strAviName4_1 As String, m_strAviName4_2 As String

    Public m_cVideoInputDlg As MyVideoInputDlg

    Public m_cAudioInputDlg As MyAudioInputDlg

    Public m_cVideoPropertytDlg As MyVideoPropertyDlg

    Public m_cSnapShotDlg As MySnapShotDlg

    Public m_cRecordingDlg As MyRecordingDlg

    Public m_cShareRecordingDlg As MyShareRecordingDlg

    Private Sub MySetupControl_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        ' GET CURRENT DIRECTORY
        '
        m_strCurrentDir = System.IO.Directory.GetCurrentDirectory()

        m_cVideoInputDlg = New MyVideoInputDlg()

        m_cVideoInputDlg.m_pMainForm = Me

        m_cVideoInputDlg.Hide()

        m_cAudioInputDlg = New MyAudioInputDlg()

        m_cAudioInputDlg.m_pMainForm = Me

        m_cAudioInputDlg.Hide()

        m_cVideoPropertytDlg = New MyVideoPropertyDlg()

        m_cVideoPropertytDlg.m_pMainForm = Me

        m_cVideoPropertytDlg.Hide()

        m_cSnapShotDlg = New MySnapShotDlg()

        m_cSnapShotDlg.Hide()

        m_cRecordingDlg = New MyRecordingDlg()

        m_cRecordingDlg.m_pMainForm = Me

        m_cRecordingDlg.Hide()

        m_cShareRecordingDlg = New MyShareRecordingDlg()

        m_cShareRecordingDlg.m_pSetupForm = Me

        m_cShareRecordingDlg.Hide()

        m_strAviName1_1 = m_strCurrentDir + "\CH01_1.AVI"

        m_strAviName1_2 = m_strCurrentDir + "\CH01_2.AVI"

        m_strAviName2_1 = m_strCurrentDir + "\CH02_1.AVI"

        m_strAviName2_2 = m_strCurrentDir + "\CH02_2.AVI"

        m_strAviName3_1 = m_strCurrentDir + "\CH03_1.AVI"

        m_strAviName3_2 = m_strCurrentDir + "\CH03_2.AVI"

        m_strAviName4_1 = m_strCurrentDir + "\CH04_1.AVI"

        m_strAviName4_2 = m_strCurrentDir + "\CH04_2.AVI"

        timerCheckSignal.Enabled = True

    End Sub

    Private Sub MySetupControl_FormClosed(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed

    End Sub

    Private Sub timerCheckSignal_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles timerCheckSignal.Tick

        m_hCapDev1 = m_pMainForm.m_hCapDev(0)

        m_hCapDev2 = m_pMainForm.m_hCapDev(1)

        m_hCapDev3 = m_pMainForm.m_hCapDev(2)

        m_hCapDev4 = m_pMainForm.m_hCapDev(3)

        m_cVideoInputDlg.m_hCapDev(0) = m_hCapDev1

        m_cVideoInputDlg.m_hCapDev(1) = m_hCapDev2

        m_cVideoInputDlg.m_hCapDev(2) = m_hCapDev3

        m_cVideoInputDlg.m_hCapDev(3) = m_hCapDev4

        m_cRecordingDlg.m_bNoSignal1 = m_bNoSignal1

        m_cRecordingDlg.m_bNoSignal2 = m_bNoSignal2

        m_cRecordingDlg.m_bNoSignal3 = m_bNoSignal3

        m_cRecordingDlg.m_bNoSignal4 = m_bNoSignal4

    End Sub

    Private Sub timerShowInfo_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles timerShowInfo.Tick

        m_scDeviceFormatInformation1.Text = m_strFormatChangedOutput1

        m_scDeviceFormatInformation2.Text = m_strFormatChangedOutput2

        m_scDeviceFormatInformation3.Text = m_strFormatChangedOutput3

        m_scDeviceFormatInformation4.Text = m_strFormatChangedOutput4

    End Sub

    Private Sub m_btnVideoInput_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnVideoInput.Click

        m_cVideoInputDlg.m_hCapDev(0) = m_pMainForm.m_hCapDev(0)

        m_cVideoInputDlg.m_hCapDev(1) = m_pMainForm.m_hCapDev(1)

        m_cVideoInputDlg.m_hCapDev(2) = m_pMainForm.m_hCapDev(2)

        m_cVideoInputDlg.m_hCapDev(3) = m_pMainForm.m_hCapDev(3)

        m_cVideoInputDlg.Show()

    End Sub

    Private Sub m_btnVideoQuality_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnVideoQuality.Click

        m_cVideoPropertytDlg.m_hCapDev(0) = m_pMainForm.m_hCapDev(0)

        m_cVideoPropertytDlg.m_hCapDev(1) = m_pMainForm.m_hCapDev(1)

        m_cVideoPropertytDlg.m_hCapDev(2) = m_pMainForm.m_hCapDev(2)

        m_cVideoPropertytDlg.m_hCapDev(3) = m_pMainForm.m_hCapDev(3)

        m_cVideoPropertytDlg.Show()

    End Sub

    Private Sub m_btnFileRecording_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnFileRecording.Click

        m_cRecordingDlg.m_hCapDev(0) = m_pMainForm.m_hCapDev(0)

        m_cRecordingDlg.m_hCapDev(1) = m_pMainForm.m_hCapDev(1)

        m_cRecordingDlg.m_hCapDev(2) = m_pMainForm.m_hCapDev(2)

        m_cRecordingDlg.m_hCapDev(3) = m_pMainForm.m_hCapDev(3)

        m_cRecordingDlg.Show()

    End Sub

    Private Sub m_btnAudioInput_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnAudioInput.Click

        m_cAudioInputDlg.m_hCapDev(0) = m_pMainForm.m_hCapDev(0)

        m_cAudioInputDlg.m_hCapDev(1) = m_pMainForm.m_hCapDev(1)

        m_cAudioInputDlg.m_hCapDev(2) = m_pMainForm.m_hCapDev(2)

        m_cAudioInputDlg.m_hCapDev(3) = m_pMainForm.m_hCapDev(3)

        m_cAudioInputDlg.Show()

    End Sub

    Private Sub m_btnSnapShot_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnSnapShot.Click

        m_cSnapShotDlg.m_hCapDev(0) = m_pMainForm.m_hCapDev(0)

        m_cSnapShotDlg.m_hCapDev(1) = m_pMainForm.m_hCapDev(1)

        m_cSnapShotDlg.m_hCapDev(2) = m_pMainForm.m_hCapDev(2)

        m_cSnapShotDlg.m_hCapDev(3) = m_pMainForm.m_hCapDev(3)

        m_cSnapShotDlg.Show()

    End Sub

    Private Sub m_btnShareRecording_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_btnShareRecording.Click

        m_cShareRecordingDlg.m_hCapDev(0) = m_pMainForm.m_hCapDev(0)

        m_cShareRecordingDlg.m_hCapDev(1) = m_pMainForm.m_hCapDev(1)

        m_cShareRecordingDlg.m_hCapDev(2) = m_pMainForm.m_hCapDev(2)

        m_cShareRecordingDlg.m_hCapDev(3) = m_pMainForm.m_hCapDev(3)

        m_cShareRecordingDlg.Show()

    End Sub

    Private Sub m_checkShowCloneVideo_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkShowCloneVideo.Click

        Dim bShowCloneVideo As Boolean = m_checkShowCloneVideo.Checked

        If bShowCloneVideo = True Then

            m_pMainForm.ShowCloneVideo(True)

        Else

            m_pMainForm.ShowCloneVideo(False)

        End If

    End Sub

    Private Sub m_checkAutoDeinterlace_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles m_checkAutoDeinterlace.Click

        m_bAutoDeinterlace = m_checkAutoDeinterlace.Checked

        m_hCapDev1 = m_pMainForm.m_hCapDev(0)

        m_hCapDev2 = m_pMainForm.m_hCapDev(1)

        m_hCapDev3 = m_pMainForm.m_hCapDev(2)

        m_hCapDev4 = m_pMainForm.m_hCapDev(3)

        If m_hCapDev1 <> 0 Then

            If m_bAutoDeinterlace = True Then

                EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev1, 1)

            Else

                EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev1, 0)

            End If

        End If

        If m_hCapDev2 <> 0 Then

            If m_bAutoDeinterlace = True Then

                EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev2, 1)

            Else

                EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev2, 0)

            End If

        End If

        If m_hCapDev3 <> 0 Then

            If m_bAutoDeinterlace = True Then

                EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev3, 1)

            Else

                EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev3, 0)

            End If

        End If

        If m_hCapDev4 <> 0 Then

            If m_bAutoDeinterlace = True Then

                EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev4, 1)

            Else

                EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev4, 0)

            End If

        End If

    End Sub


End Class