// MyLiveAV.cpp: implementation of the MyLiveAV class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "MyLiveAV.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern BOOL g_bSaveAVIFile;

SYSTEMTIME g_stStartLiveTime[ 32 ];

SYSTEMTIME g_stEndLiveTime[ 32 ];

double g_dLiveFrameRate[ 32 ] = { 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000 };

ULONG  g_nLiveVideoFrameNumber[ 32 ] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

UINT  g_hLiveTimerHandle[ 32  ] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

// DISPATCH CPU THREAD
//
ULONG g_n_IsSetThread[ 32 ] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

extern CString g_strLiveFrameRate[ 32 ];

extern ULONG g_nRecVideoFrameNumber[ 32 ];

typedef VOID (*TFCALLBACK)( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime );

VOID LiveTimerProc( ULONG nCHID, HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime )
{
	ULONG i = nCHID - 1;
	
	if ( g_nLiveVideoFrameNumber[ i ] != 0 )
	{
		CTimeSpan timeSpan;

		CTime timeCurrent = CTime::GetCurrentTime();

		CTime timeStart( g_stStartLiveTime[ i ] );

		timeSpan = timeCurrent - timeStart;

		LONGLONG nSeconds = 0;

		nSeconds = timeSpan.GetTotalSeconds();

		if (nSeconds == 0) nSeconds = 1;

		g_dLiveFrameRate[ i ] = (double)g_nLiveVideoFrameNumber[ i ] / (double)nSeconds;

		g_strLiveFrameRate[ i ].Format( "%.3f", g_dLiveFrameRate[ i ] );
	}
}

VOID LiveTimerProc1( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc( 1, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc2( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc( 2, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc3( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc( 3, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc4( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc( 4, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc5( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc( 5, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc6( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc( 6, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc7( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc( 7, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc8( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc( 8, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc9( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc( 9, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc10( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc( 10, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc11( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc( 11, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc12( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc( 12, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc13( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc( 13, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc14( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc( 14, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc15( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc( 15, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc16( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc( 16, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc17( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc( 17, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc18( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc( 18, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc19( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc( 19, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc20( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc( 20, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc21( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc( 21, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc22( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc( 22, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc23( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc( 23, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc24( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc( 24, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc25( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc( 25, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc26( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc( 26, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc27( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc( 27, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc28( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc( 28, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc29( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc( 29, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc30( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc( 30, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc31( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc( 31, hWnd, nMsg, nIdEvent, dwTime ); }
VOID LiveTimerProc32( HWND hWnd, UINT nMsg, UINT nIdEvent, DWORD dwTime) { LiveTimerProc( 32, hWnd, nMsg, nIdEvent, dwTime ); }

TFCALLBACK g_LiveTimerProc[ 32 ] = 
{  
	LiveTimerProc1, LiveTimerProc2, LiveTimerProc3, LiveTimerProc4, LiveTimerProc5, LiveTimerProc6, LiveTimerProc7, LiveTimerProc8, LiveTimerProc9, LiveTimerProc10, LiveTimerProc11, LiveTimerProc12, LiveTimerProc13, LiveTimerProc14, LiveTimerProc15, LiveTimerProc16, LiveTimerProc17, LiveTimerProc18, LiveTimerProc19, LiveTimerProc20, LiveTimerProc21, LiveTimerProc22, LiveTimerProc23, LiveTimerProc24, LiveTimerProc25, LiveTimerProc26, LiveTimerProc27, LiveTimerProc28, LiveTimerProc29, LiveTimerProc30, LiveTimerProc31, LiveTimerProc32
};

// CALLBACK FUNCTION
//
BOOL on_process_live_video_frame_buffer( ULONG nChannelNumber, double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	ULONG i = nChannelNumber - 1;

	MyLiveAV * pLiveAV = (MyLiveAV *)(pUserData);

	CString str;	

	if ( pLiveAV != NULL && pLiveAV->GetChannelID() == nChannelNumber )
	{		
		if ( pLiveAV->m_strChipName == "TW6802 PCI" || pLiveAV->m_strChipName == "CX2581 PCI" || pLiveAV->m_strChipName == "SA7160 PCI" )
		{			
			// CVRSDK : UPDATE VIDEO BUFFER ON THE CHANNEL WINDOW
			//
			CVRSDK_UPDATE_VIDEO_BUFFER( pLiveAV->m_pCustomChannelWindow, pBuffer, MAKEFOURCC('Y', 'U', 'Y', '2'), pLiveAV->m_nWidth, pLiveAV->m_nHeight, TRUE );
		}

		if ( pLiveAV->m_strChipName == "AH8400 PCI")
		{
			// CVRSDK : UPDATE VIDEO BUFFER ON THE CHANNEL WINDOW
			//
			CVRSDK_UPDATE_VIDEO_BUFFER( pLiveAV->m_pCustomChannelWindow, pBuffer, MAKEFOURCC('U', 'Y', 'V', 'Y'), pLiveAV->m_nWidth, pLiveAV->m_nHeight, TRUE );
		}

		if ( pLiveAV->m_strChipName == "FH8735 PCI" || pLiveAV->m_strChipName == "TW5864 PCI" || pLiveAV->m_strChipName == "TW2809 PCI" )
		{
			// CVRSDK : UPDATE VIDEO BUFFER ON THE CHANNEL WINDOW
			//
			CVRSDK_UPDATE_VIDEO_BUFFER( pLiveAV->m_pCustomChannelWindow, pBuffer, MAKEFOURCC('Y', 'V', '1', '2'), pLiveAV->m_nWidth, pLiveAV->m_nHeight, TRUE );			
		}		

		if ( g_nLiveVideoFrameNumber[ i ] == 0 )
		{
			GetLocalTime( &g_stStartLiveTime[ i ] );
		}

		g_nLiveVideoFrameNumber[ i ] += 1;

		if ( pLiveAV->m_strChipName == "AH8400 PCI" || pLiveAV->m_strChipName == "FH8735 PCI" || pLiveAV->m_strChipName == "TW5864 PCI" || pLiveAV->m_strChipName == "TW2809 PCI" ) 
		{ 
			// return TRUE;

			return FALSE;
		}

		// ENCODE VIDEO DATA
		//
		MySwEncodeAV * pSwEncodeAV  = pLiveAV->GetSwEncodeAV();

		MyRecordAV * pRecordAV = pLiveAV->GetRecordAV();

		if ( pSwEncodeAV != NULL && pRecordAV != NULL )
		{
			BOOL bIsRecord = (pRecordAV->m_nFileRendererRecordState == 0x00000002) ? TRUE : FALSE;

			DEVICE_HANDLE hVideoEncoderDev = pSwEncodeAV->m_hVideoEncoderDev;

			DEVICE_HANDLE hFileDev = pRecordAV->m_hFileRendererDev;

			BOOL bIsRecord2 = TRUE;

			ULONG nDropFrame = pLiveAV->m_nDropFrame;

			// DROP FRAME
			//
			if ( nDropFrame != 0 )
			{
				if ( (g_nLiveVideoFrameNumber[ i ] % nDropFrame) == 0 ) { bIsRecord2 = TRUE; } else { bIsRecord2 = FALSE; }
			}

			if( bIsKeyFrame )
			{
				// WAITING KEY FRAME
				//
				if( pRecordAV->m_nFileRendererRecordState == 0x00000001 ) 
				{
					pRecordAV->m_nFileRendererRecordState = 0x00000002; // TO GOTO START STATE

					bIsRecord = TRUE;
				}
			}

			bIsRecord &= bIsRecord2; 

			if( bIsRecord ) 
			{			
				BYTE * pStreamBuffer = NULL;

				ULONG  nStreamBufferLen = 0;

				BOOL   bIsKeyFrame = FALSE;				

				BOOL bSetDIInterlace = FALSE;

				bSetDIInterlace = pLiveAV->SetDIDeinterlace( pBuffer,  nBufferLen );

				// COMPRESSED DATA
				//				
				if ( AMESDK_CODEC_ENCODE( hVideoEncoderDev, pBuffer, MAKEFOURCC('Y', 'U', 'Y', '2'), pSwEncodeAV->m_nFrameWidth, pSwEncodeAV->m_nFrameHeight, &pStreamBuffer, &nStreamBufferLen, &bIsKeyFrame ) )
				{
					g_nRecVideoFrameNumber[ i ] += 1;					
				}

				// SAVE VIDEO DATA
				//
				if ( g_bSaveAVIFile )
				{
					AMESDK_FILE_SET_VIDEO_STREAM_BUFFER( hFileDev, pStreamBuffer, nStreamBufferLen, bIsKeyFrame );
				}
			}
		}
	}	

	// return TRUE;	

	return FALSE;
}

BOOL on_process_live_video_frame_buffer_CH01( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 1, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH02( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 2, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH03( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 3, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH04( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 4, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH05( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 5, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH06( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 6, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH07( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 7, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH08( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 8, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_live_video_frame_buffer_CH09( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer(  9, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH10( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 10, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH11( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 11, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH12( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 12, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH13( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 13, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH14( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 14, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH15( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 15, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH16( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 16, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_live_video_frame_buffer_CH17( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 17, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH18( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 18, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH19( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 19, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH20( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 20, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH21( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 21, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH22( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 22, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH23( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 23, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH24( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 24, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_live_video_frame_buffer_CH25( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 25, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH26( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 26, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH27( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 27, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH28( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 28, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH29( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 29, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH30( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 30, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH31( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 31, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }
BOOL on_process_live_video_frame_buffer_CH32( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_live_video_frame_buffer( 32, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

PF_BUFFER_CALLBACK g_on_live_video_callback[ 32 ] = 
{  
	on_process_live_video_frame_buffer_CH01, 
	on_process_live_video_frame_buffer_CH02, 
	on_process_live_video_frame_buffer_CH03, 
	on_process_live_video_frame_buffer_CH04, 
	on_process_live_video_frame_buffer_CH05, 
	on_process_live_video_frame_buffer_CH06, 
	on_process_live_video_frame_buffer_CH07, 
	on_process_live_video_frame_buffer_CH08,
	on_process_live_video_frame_buffer_CH09, 
	on_process_live_video_frame_buffer_CH10, 
	on_process_live_video_frame_buffer_CH11, 
	on_process_live_video_frame_buffer_CH12, 
	on_process_live_video_frame_buffer_CH13, 
	on_process_live_video_frame_buffer_CH14, 
	on_process_live_video_frame_buffer_CH15, 
	on_process_live_video_frame_buffer_CH16,
	on_process_live_video_frame_buffer_CH17, 
	on_process_live_video_frame_buffer_CH18, 
	on_process_live_video_frame_buffer_CH19, 
	on_process_live_video_frame_buffer_CH20, 
	on_process_live_video_frame_buffer_CH21, 
	on_process_live_video_frame_buffer_CH22, 
	on_process_live_video_frame_buffer_CH23, 
	on_process_live_video_frame_buffer_CH24,
	on_process_live_video_frame_buffer_CH25, 
	on_process_live_video_frame_buffer_CH26, 
	on_process_live_video_frame_buffer_CH27, 
	on_process_live_video_frame_buffer_CH28, 
	on_process_live_video_frame_buffer_CH29, 
	on_process_live_video_frame_buffer_CH30, 
	on_process_live_video_frame_buffer_CH31, 
	on_process_live_video_frame_buffer_CH32
};

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

MyLiveAV::MyLiveAV()
{
	m_hVideoDev					= 0xFFFFFFFF;

	m_hAudioDev					= 0xFFFFFFFF;

	m_hDeinterlaceVideoDev = 0xFFFFFFFF;

	m_pMySwEncodeAV				= NULL;

	m_pMyHwEncodeAV				= NULL;

	m_hWnd						= NULL;

	m_pCustomChannelWindow		= NULL;	

	m_bConnect					= FALSE;	

	m_nChannelID				= 0;	

	m_nDropFrame				= 0;

	m_nWidth					= 352;
	
	m_nHeight					= 240;

	m_dLiveFrameRate = 29.97;
}

MyLiveAV::~MyLiveAV()
{
	Disconnect();
}

BOOL MyLiveAV::Connect()
{
	if (m_nChannelID == 0) { return FALSE; }

	if (IsConnected() == TRUE) { return TRUE; }		

	USES_CONVERSION;

	m_hVideoDev = 0xFFFFFFFF;	

	g_nLiveVideoFrameNumber[ (m_nChannelID - 1) ] = 0;

	if ( m_strChipName == "TW6802 PCI" || m_strChipName == "SA7160 PCI" || m_strChipName == "CX2581 PCI" )
	{		
		m_hVideoDev = AMESDK_CREATE( m_strChipName.GetBuffer( 256 ), ( m_nChannelID - 1 ), 0,
			
					  NULL, g_on_live_video_callback[ m_nChannelID - 1 ], this );		
	}	

	if ( m_strChipName == "AH8400 PCI" || m_strChipName == "FH8735 PCI" || m_strChipName == "TW5864 PCI" || m_strChipName == "TW2809 PCI" )
	{
		m_hVideoDev = AMESDK_CREATE( m_strChipName.GetBuffer( 256 ), ( m_nChannelID - 1 ), 0,
			
					  NULL, g_on_live_video_callback[ m_nChannelID - 1 ], this );
	}


	m_strChipName.ReleaseBuffer();

	if( m_hVideoDev & 0x80000000 ) 
	{
		m_hVideoDev = 0xFFFFFFFF;

		m_bConnect = FALSE;

		return m_bConnect;
	}
	else
	{
		m_bConnect = TRUE;
	}

	m_hDeinterlaceVideoDev = AMESDK_CREATE( "Common Analog Deinterlacer", ( m_nChannelID - 1 ), 16, NULL, NULL, NULL );

	if( m_hDeinterlaceVideoDev & 0x80000000 ) 
	{ 
		m_hDeinterlaceVideoDev = 0xFFFFFFFF;
	}

	return m_bConnect;
}

BOOL MyLiveAV::Disconnect()
{
    if (IsConnected() == FALSE)  {  return FALSE;  }

	g_nLiveVideoFrameNumber[ (m_nChannelID - 1) ] = 0;

	::KillTimer( NULL, g_hLiveTimerHandle[ m_nChannelID - 1 ] );

	g_hLiveTimerHandle[ m_nChannelID - 1 ] = 0;	

	BOOL bDisConnect = FALSE;

	if( m_hDeinterlaceVideoDev != 0xFFFFFFFF ) 
	{
		AMESDK_DESTROY( m_hDeinterlaceVideoDev ); 

		m_hDeinterlaceVideoDev = 0xFFFFFFFF;
	}

	if( m_hVideoDev != 0xFFFFFFFF ) 
	{ 
		bDisConnect = AMESDK_DESTROY( m_hVideoDev ); 

		m_hVideoDev = 0xFFFFFFFF; 

		m_bConnect = FALSE;

		return bDisConnect;
	}

	return bDisConnect;
}

BOOL MyLiveAV::SetVideoStandard( ULONG nStandard )
{
	if (IsConnected() == FALSE) { return FALSE; }

	BOOL bSet = AMESDK_SET_STANDARD( m_hVideoDev, nStandard );

	return bSet;
}

BOOL MyLiveAV::SetVideoFormat(ULONG nColorSpaceType, ULONG nWidth, ULONG nHeight, ULONG nBitCount, DOUBLE dFrameRate)
{
	if (IsConnected() == FALSE) { return FALSE; }

	BOOL bSet = FALSE;

	bSet = AMESDK_SET_FORMAT(m_hVideoDev, nColorSpaceType, nWidth, nHeight, nBitCount, dFrameRate);

	AMESDK_SET_FORMAT(m_hDeinterlaceVideoDev, nColorSpaceType, nWidth, nHeight, nBitCount, dFrameRate);

	m_nWidth = nWidth;
	
	m_nHeight = nHeight;

	m_dLiveFrameRate = dFrameRate;

	return bSet;
}

BOOL MyLiveAV::GetVideoFormat(ULONG * pnColorSpaceType, ULONG * pnWidth, ULONG * pnHeight, ULONG * pnBitCount, DOUBLE * pdFrameRate)
{
	if (IsConnected() == FALSE) { return FALSE; }

	BOOL bGet = FALSE;

	bGet = AMESDK_GET_FORMAT(m_hVideoDev, pnColorSpaceType, pnWidth, pnHeight, pnBitCount, pdFrameRate );

	return bGet;
}

BOOL MyLiveAV::SetVideoDeinterlace(ULONG nDeinterlace, ULONG nSubChannelNumber)
{
	if (IsConnected() == FALSE) { return FALSE; }

	BOOL bSet = FALSE;

	bSet = AMESDK_SET_DEINTERLACE( m_hVideoDev, nDeinterlace, 0 ); // NOTE!! 352  240 IS PROGRESSIVE FIELD FORMAT

	AMESDK_SET_DEINTERLACE( m_hVideoDev, nDeinterlace, 1 );

	AMESDK_SET_DEINTERLACE( m_hDeinterlaceVideoDev, nDeinterlace, 0 );

	AMESDK_SET_DEINTERLACE( m_hDeinterlaceVideoDev, nDeinterlace, 1 );	

	return bSet;
}

BOOL MyLiveAV::SetDIDeinterlace( BYTE * pFrameBuffer, ULONG nFrameBufferSize )
{
	if (IsConnected() == FALSE) { return FALSE; }

	BOOL bSet = FALSE;

	bSet = AMESDK_DI_DEINTERLACE( m_hDeinterlaceVideoDev, pFrameBuffer, nFrameBufferSize );

	return bSet;
}

BOOL MyLiveAV::SetVideoProperty(ULONG nProperty, ULONG nValue, ULONG nSubChannelNumber)
{
	if (IsConnected() == FALSE) { return FALSE; }

	BOOL bSet = AMESDK_SET_VIDEOPROCAMP_PROPERTY( m_hVideoDev, nProperty, nValue, nSubChannelNumber );

	return bSet;
}

BOOL MyLiveAV::SetCustomProperty(ULONG nProperty, ULONG nValue)
{
	if (IsConnected() == FALSE) { return FALSE; }

	BOOL bSet = AMESDK_SET_CUSTOM_PROPERTY( m_hVideoDev, nProperty, nValue );

	return bSet;
}

BOOL MyLiveAV::LiveRun()
{
	if (IsConnected() == FALSE) { return FALSE; }
	
	BOOL bRun = AMESDK_RUN( m_hVideoDev );	

	g_nLiveVideoFrameNumber[ m_nChannelID - 1 ] = 0;

	g_hLiveTimerHandle[ m_nChannelID - 1 ] = ::SetTimer( NULL, 0x00000001, 1000, (TIMERPROC) g_LiveTimerProc[ m_nChannelID - 1 ] );
		 
	return bRun;
}

BOOL MyLiveAV::LiveStop()
{
	if (IsConnected() == FALSE) { return FALSE; }
	
	BOOL bStop = AMESDK_STOP( m_hVideoDev );

	g_nLiveVideoFrameNumber[ m_nChannelID - 1 ] = 0;

	::KillTimer( NULL, g_hLiveTimerHandle[ m_nChannelID - 1 ] );

	g_hLiveTimerHandle[ m_nChannelID - 1 ] = 0;	

	return bStop;
}

BOOL MyLiveAV::RefreshDisplay()
{
	if (IsConnected() == FALSE) { return FALSE; }

	BOOL bFresh = AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev, 0 );	

	return bFresh;
}

BOOL MyLiveAV::SnapshotBMP(CHAR *pszFilePathName)
{
	if (IsConnected() == FALSE) { return FALSE; }

	BOOL bSnapshot = FALSE;

	bSnapshot = AMESDK_OTHER_SNAPSHOT_BMP( m_hVideoDev, pszFilePathName );

	return bSnapshot;
}

BOOL MyLiveAV::SnapshotJPG(CHAR *pszFilePathName, ULONG nQuality)
{
	if (IsConnected() == FALSE) { return FALSE; }

	BOOL bSnapshot = FALSE;

	bSnapshot = AMESDK_OTHER_SNAPSHOT_JPG( m_hVideoDev, pszFilePathName, nQuality );	

	return bSnapshot;
}

BOOL MyLiveAV::SetVideoInput(ULONG nInput)
{
	if (IsConnected() == FALSE) { return FALSE; }

	BOOL bSet = FALSE;

	bSet = AMESDK_SET_INPUT( m_hVideoDev, nInput );	

	return bSet;
}