Imports System.Runtime.InteropServices
Imports System.Text

Module Module1

    <DllImport("NUCUpsLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function nucupsOpenDeviceHandler(ByVal timer As Integer) As Byte
    End Function
    <DllImport("NUCUpsLib.dll", CallingConvention:=CallingConvention.Cdecl)> Sub nucupsCloseDeviceHandler()
    End Sub
    <DllImport("NUCUpsLib.dll", CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.Cdecl)> Sub getNUCUpsDevicePath(ByVal value As StringBuilder)
    End Sub
    <DllImport("NUCUpsLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function isNUCUpsConnected() As Byte
    End Function
    <DllImport("NUCUpsLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function getNUCUpsVIn() As Single
    End Function
    <DllImport("NUCUpsLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function getNUCUpsIOut() As Single
    End Function
    <DllImport("NUCUpsLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function getNUCUpsVOut() As Single
    End Function
    <DllImport("NUCUpsLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function getNUCUpsVBats(ByVal cnt As Integer) As Single
    End Function
    <DllImport("NUCUpsLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function getNUCUpsTemperature(ByVal cnt As Integer) As Single
    End Function
    <DllImport("NUCUpsLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function getNUCUpsVIgnition() As Single
    End Function
    <DllImport("NUCUpsLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function getNUCUpsPOut() As Single
    End Function
    <DllImport("NUCUpsLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function getNUCUpsVBat() As Single
    End Function
    <DllImport("NUCUpsLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function getNUCUpsVPack() As Single
    End Function
    <DllImport("NUCUpsLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function getNUCUpsIChgDchg() As Single
    End Function
    <DllImport("NUCUpsLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function getNUCUpsBatteryLevel() As Byte
    End Function
    <DllImport("NUCUpsLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function getNUCUpsMode() As Byte
    End Function
    <DllImport("NUCUpsLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function getNUCUpsVerMajor() As Byte
    End Function
    <DllImport("NUCUpsLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function getNUCUpsVerMinor() As Byte
    End Function

    <DllImport("NUCUpsLib.dll", CallingConvention:=CallingConvention.Cdecl)> Sub restartNUCUps()
    End Sub
    <DllImport("NUCUpsLib.dll", CallingConvention:=CallingConvention.Cdecl)> Sub restartNUCUpsInBootloaderMode()
    End Sub


    'Flash stuff
    <DllImport("NUCUpsLib.dll", CallingConvention:=CallingConvention.Cdecl)> Sub startNUCUpsLoadingSettings(ByVal to_file As Byte, ByVal compare_with_old As Byte)
    End Sub
    <DllImport("NUCUpsLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function getNUCUpsLoadingSettingsState() As Byte
    End Function
    <DllImport("NUCUpsLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function getNUCUpsMaxVariableCnt() As Integer
    End Function
    <DllImport("NUCUpsLib.dll", CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.Cdecl)> _
    Function getNUCUpsVariableData(ByVal cnt As UInt32, ByVal name As StringBuilder, ByVal value As StringBuilder, ByVal unit As StringBuilder, ByVal comment As StringBuilder) As Byte
    End Function
    <DllImport("NUCUpsLib.dll", CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.Cdecl)> _
    Function setNUCUpsVariableData(ByVal cnt As UInt32, ByVal value As String) As Byte
    End Function
    <DllImport("NUCUpsLib.dll", CallingConvention:=CallingConvention.Cdecl)> Sub startNUCUpsSaveSettings(ByVal from_file As Byte)
    End Sub
    <DllImport("NUCUpsLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function getNUCUpsSaveSettingsState() As Byte
    End Function

    Sub Main()
        Console.WriteLine("HIT <Esc> TO EXIT!")

        Dim state As Integer

        nucupsOpenDeviceHandler(1000)
        If (isNUCUpsConnected() = 1) Then
            Console.WriteLine("NUCUps opened!")
            System.Threading.Thread.Sleep(500) 'it's recommended to give a few miliseconds before the first read otherwise the first read might be 0 

            'the library reads the NUCUps values in every 1000 msec (once per second)
            'therefore is useless to read them faster from here

            Dim path As StringBuilder = New StringBuilder(1024)
            getNUCUpsDevicePath(path)

            Console.Write(" firmware: ")
            Console.Write(getNUCUpsVerMajor())
            Console.Write(".")
            Console.Write(getNUCUpsVerMinor())
            Console.WriteLine()
            Console.Write(" path: ")
            Console.Write(path)
            Console.WriteLine()
            Console.WriteLine("------------------------------")
        Else
            Console.WriteLine("NUCUps not found!")
        End If

        Dim ch As ConsoleKey = ConsoleKey.Backspace 'no matter, just not Esc

        While (ch <> ConsoleKey.Escape)
            If (Console.KeyAvailable) Then
                ch = Console.ReadKey().Key
                If (ch <> ConsoleKey.Escape) Then
                    Console.WriteLine("Press again:")
                    Console.WriteLine(" L.Load flash ")
                    Console.WriteLine(" Q.Set flash 1")
                    Console.WriteLine(" W.Set flash 2")
                    Console.WriteLine(" A.Save settings to file")
                    Console.WriteLine(" S.Load settings from file")
                    Dim readch As Char = Console.ReadKey().KeyChar
                    Select Case readch
                        Case "l"c, "L"c
                            Console.WriteLine("Loading flash values. Wait ...")
                            startNUCUpsLoadingSettings(0, 0)
                            Dim mytimeout As Integer = 0
                            While ((getNUCUpsLoadingSettingsState() < 100) And (mytimeout < 20)) 'wait for 10 seconds
                                Console.WriteLine("Loading ")
                                Console.Write(getNUCUpsLoadingSettingsState())
                                Console.Write("%")
                                mytimeout = mytimeout + 1
                                System.Threading.Thread.Sleep(500)
                            End While
                            Console.WriteLine("Loading final: ")
                            Console.Write(getNUCUpsLoadingSettingsState())
                            Console.Write("%") '100=OK, F0-FF=ERRORCODE
                            If (getNUCUpsLoadingSettingsState() = 100) Then 'succesfull
                                Dim var_max As Integer = getNUCUpsMaxVariableCnt()
                                Dim name As StringBuilder = New StringBuilder(256)
                                Dim value As StringBuilder = New StringBuilder(256)
                                Dim unit As StringBuilder = New StringBuilder(256)
                                Dim comment As StringBuilder = New StringBuilder(1024)

                                For i As UInt32 = 0 To var_max
                                    If (getNUCUpsVariableData(i, name, value, unit, comment) <> 0) Then
                                        Console.Write("[")
                                        Console.Write(i)
                                        Console.Write("] ")
                                        Console.Write(name.ToString())
                                        Console.Write("=")
                                        Console.Write(value.ToString())
                                        Console.Write(" ")
                                        Console.Write(unit.ToString())
                                        Console.WriteLine()
                                    End If
                                Next
                            Else
                                Console.WriteLine("    ERROR: ")
                                Console.Write(getNUCUpsLoadingSettingsState())
                            End If
                        Case "a"c, "A"c
                            Console.WriteLine("Saving flash values to file. Wait ...")
                            startNUCUpsLoadingSettings(1, 0)
                            Dim mytimeout As Integer = 0
                            While ((getNUCUpsLoadingSettingsState() < 100) And (mytimeout < 20)) 'wait for 10 seconds
                                Console.WriteLine("Loading ")
                                Console.Write(getNUCUpsLoadingSettingsState())
                                Console.Write("%")
                                mytimeout = mytimeout + 1
                                System.Threading.Thread.Sleep(500)
                            End While
                            Console.WriteLine("Loading final: ")
                            Console.Write(getNUCUpsLoadingSettingsState())
                            Console.Write("%") '100=OK, F0-FF=ERRORCODE
                        Case "s"c, "S"c
                            Console.WriteLine("Loading flash values from file. Wait ...")
                            startNUCUpsSaveSettings(1)
                            Dim mytimeout As Integer = 0
                            While ((getNUCUpsSaveSettingsState() < 100) And (mytimeout < 20)) 'wait for 10 seconds
                                Console.WriteLine("Saving ")
                                Console.Write(getNUCUpsSaveSettingsState())
                                Console.Write("%")
                                mytimeout = mytimeout + 1
                                System.Threading.Thread.Sleep(500)
                            End While
                            Console.WriteLine("Saving final: ")
                            Console.Write(getNUCUpsSaveSettingsState())
                            Console.Write("%") '100=OK, F0-FF=ERRORCODE
                        Case "q"c, "Q"c, "w"c, "W"c
                            If ((readch = "q"c) Or (readch = "Q"c)) Then
                                setNUCUpsVariableData(48, "3111") 'POUT_HIGH_THRESHOLD
                                setNUCUpsVariableData(20, "11111111") 'CONFIG2
                            Else
                                setNUCUpsVariableData(48, "3000") 'POUT_HIGH_THRESHOLD
                                setNUCUpsVariableData(20, "00000000") 'CONFIG2
                            End If

                            startNUCUpsSaveSettings(0)
                            Dim mytimeout As Integer = 0
                            While ((getNUCUpsSaveSettingsState() < 100) And (mytimeout < 20)) 'wait for 10 seconds
                                Console.WriteLine("Saving ")
                                Console.Write(getNUCUpsSaveSettingsState())
                                Console.Write("%")
                                mytimeout = mytimeout + 1
                                System.Threading.Thread.Sleep(500)
                            End While
                            Console.WriteLine("Saving final: ")
                            Console.Write(getNUCUpsSaveSettingsState())
                            Console.Write("%") '100=OK, F0-FF=ERRORCODE
                    End Select
                End If
            Else
                If (isNUCUpsConnected() = 0) Then
                    'nucCloseDeviceHandler();//close it only if you do not want auto reconnect
                    Console.WriteLine("No device")
                Else
                    Console.Write("Mode=")
                    Console.Write(getNUCUpsMode())
                    Console.Write(" VIn=")
                    Console.Write(getNUCUpsVIn())
                    Console.Write(" VIgn=")
                    Console.Write(getNUCUpsVIgnition())
                    Console.Write(" VBat=")
                    Console.Write(getNUCUpsVBat())
                    Console.Write(" VOut=")
                    Console.Write(getNUCUpsVOut())
                    Console.Write(" POut=")
                    Console.Write(getNUCUpsPOut())
                    Console.Write(" IOut=")
                    Console.Write(getNUCUpsIOut())
                    Console.Write(" Capacity=")
                    Console.Write(getNUCUpsBatteryLevel())
                    Console.Write(" Ichg=")
                    Console.Write(getNUCUpsIChgDchg())
                    Console.WriteLine()
                    Console.Write("    Cells=")
                    For i As Integer = 0 To 3
                        Console.Write("[")
                        Console.Write(i)
                        Console.Write(" ")
                        Console.Write(getNUCUpsVBats(i))
                        Console.Write("V ")
                        Console.Write(getNUCUpsTemperature(i))
                        Console.Write("C] ")
                    Next
                    Console.WriteLine()
                End If
                System.Threading.Thread.Sleep(1000)
            End If
        End While
        nucupsCloseDeviceHandler()
    End Sub

End Module
