// DcDcUsbDlg.h : header file
//

#pragma once

#include "HIDDcDcUsb.h"
#include "afxwin.h"
#include "PanelStatus.h"
#include "PanelSettings.h"
#include "PanelScripts.h"
#include "DeviceDetector.h"

// CDcDcUsbDlg dialog
class CDcDcUsbDlg : public CDialog, public DeviceDetector
{
// Construction
public:
	CDcDcUsbDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	enum { IDD = IDD_DCDCUSB_DIALOG };

	enum{
		PANEL_NONE,
		PANEL_STATUS,
		PANEL_SETTINGS,
		PANEL_SCRIPTS
	};

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support


// Implementation
public:
	void parseMessage(HArray* parray);
	virtual void deviceChanged();

	HIDDcDcUsb* m_pDcDcUsb;
	CPanelStatus* m_pPanelStatus;
	CPanelSettings* m_pPanelSettings;
	CPanelScripts* m_pPanelScripts;
	int m_nActivePanel;

protected:
	UINT_PTR m_nMainTimer;
	UINT_PTR m_nRefreshTimer;
	int m_nVoltageCfg;
	bool m_bRefreshStatus;

	unsigned char m_bVersion;

	HICON m_hIcon;

	// Generated message map functions
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnDestroy();
	afx_msg void OnTimer(UINT_PTR nIDEvent);
	CString m_strVIn;
	CString m_strIgn;
	CString m_strVOut;
	CEdit m_eVout;
	afx_msg void OnBnClickedCheckAuxvin();
	afx_msg void OnBnClickedCheckPwsw();
	afx_msg void OnBnClickedCheckOutput();
	afx_msg void OnBnClickedButtonVoutSet();
	afx_msg void OnBnClickedButtonVoutUp();
	afx_msg void OnBnClickedButtonVoutDown();
	CButton m_bAuxVin;
	CButton m_bPowerSwitch;
	CButton m_bOutput;
	CButton m_bPanelStatus;
	CButton m_bPanelSettings;
	CButton m_bPanelScripts;
	CButton m_bPanelMinimize;
	afx_msg void OnBnClickedCheckPanelStatus();
	afx_msg void OnBnClickedCheckPanelSettings();
	afx_msg void OnBnClickedCheckPanelMini();
	afx_msg void OnBnClickedCheckPanelScripts();
	afx_msg void OnBnClickedCancel();
	afx_msg void OnBnClickedOk();
	afx_msg void OnBnClickedButtonVoutSetSave();
	CButton m_buttonSetSave;
};
